;Lisp Code for Test Analysis by Ruben Ledesma (Jan-Dec, 2001). 
 
(defun my-predictor-index (x y data) (select (column-list data) (remove x (iseq y))))

;*proto*

;*slots*

(defmeth reliability-model-object-proto :dialog-value
  (&optional (values nil set))
  (if set (setf (slot-value 'dialog-value) values))
  (slot-value 'dialog-value))

(defmeth reliability-model-object-proto :data
  (&optional (values nil set))
  (if set (setf (slot-value 'data) values))
  (slot-value 'data))

(defmeth reliability-model-object-proto :cronbach
  (&optional (values nil set))
  (if set (setf (slot-value 'cronbach) values))
  (slot-value 'cronbach))

(defmeth reliability-model-object-proto :scale
  (&optional (values nil set))
  (if set (setf (slot-value 'scale) values))
  (slot-value 'scale))

(defmeth reliability-model-object-proto :scale-if
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-if) values))
  (slot-value 'scale-if))

(defmeth reliability-model-object-proto :n-items
  (&optional (values nil set))
  (if set (setf (slot-value 'n-items) values))
  (slot-value 'n-items))

(defmeth reliability-model-object-proto :item-variances
  (&optional (values nil set))
  (if set (setf (slot-value 'item-variances) values))
  (slot-value 'item-variances))

(defmeth reliability-model-object-proto :item-std
  (&optional (values nil set))
  (if set (setf (slot-value 'item-std) values))
  (slot-value 'item-std))

(defmeth reliability-model-object-proto :item-kurtosis
  (&optional (values nil set))
  (if set (setf (slot-value 'item-kurtosis) values))
  (slot-value 'item-kurtosis))

(defmeth reliability-model-object-proto :item-skewness
  (&optional (values nil set))
  (if set (setf (slot-value 'item-skewness) values))
  (slot-value 'item-skewness))

(defmeth reliability-model-object-proto :suma-item-variances
  (&optional (values nil set))
  (if set (setf (slot-value 'suma-item-variances) values))
  (slot-value 'suma-item-variances))

(defmeth reliability-model-object-proto :suma-item-variances-if
  (&optional (values nil set))
  (if set (setf (slot-value 'suma-item-variances-if) values))
  (slot-value 'suma-item-variances-if))

(defmeth reliability-model-object-proto :scale-variance
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-variance) values))
  (slot-value 'scale-variance))

(defmeth reliability-model-object-proto :scale-variance-if
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-variance-if) values))
  (slot-value 'scale-variance-if))

(defmeth reliability-model-object-proto :scale-std
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-std) values))
  (slot-value 'scale-std))

(defmeth reliability-model-object-proto :scale-std-if
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-std-if) values))
  (slot-value 'scale-std-if))

(defmeth reliability-model-object-proto :scale-kurtosis
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-kurtosis) values))
  (slot-value 'scale-kurtosis))

(defmeth reliability-model-object-proto :scale-kurtosis-if 
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-kurtosis-if) values))
  (slot-value 'scale-kurtosis-if))

(defmeth reliability-model-object-proto :scale-skewness
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-skewness) values))
  (slot-value 'scale-skewness))

(defmeth reliability-model-object-proto :scale-skewness-if
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-skewness-if) values))
  (slot-value 'scale-skewness-if))

(defmeth reliability-model-object-proto :item-means
  (&optional (values nil set))
  (if set (setf (slot-value 'item-means) values))
  (slot-value 'item-means))

(defmeth reliability-model-object-proto :scale-mean
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-mean) values))
  (slot-value 'scale-mean))

(defmeth reliability-model-object-proto :scale-mean-if
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-mean-if) values))
  (slot-value 'scale-mean-if))

(defmeth reliability-model-object-proto :alfa
  (&optional (values nil set))
  (if set (setf (slot-value 'alfa) values))
  (slot-value 'alfa))

(defmeth reliability-model-object-proto :alfa-if
  (&optional (values nil set))
  (if set (setf (slot-value 'alfa-if) values))
  (slot-value 'alfa-if))

(defmeth reliability-model-object-proto :Split-Half
  (&optional (values nil set))
  (if set (setf (slot-value 'Split-Half) values))
  (slot-value 'Split-Half))

(defmeth reliability-model-object-proto :scale-pares
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-pares) values))
  (slot-value 'scale-pares))

(defmeth reliability-model-object-proto :scale-impares
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-impares) values))
  (slot-value 'scale-impares))

(defmeth reliability-model-object-proto :kuder
  (&optional (values nil set))
  (if set (setf (slot-value 'kuder) values))
  (slot-value 'kuder))

(defmeth reliability-model-object-proto :kuder-if
  (&optional (values nil set))
  (if set (setf (slot-value 'kuder-if) values))
  (slot-value 'kuder-if))

;(defmeth reliability-model-object-proto :data-index
 ; (&optional (values nil set))
  ;(if set (setf (slot-value 'data-index) values))
  ;(slot-value 'data-index))


(defmeth reliability-model-object-proto :p
  (&optional (values nil set))
  (if set (setf (slot-value 'p) values))
  (slot-value 'p))

(defmeth reliability-model-object-proto :q
  (&optional (values nil set))
  (if set (setf (slot-value 'q) values))
  (slot-value 'q))

(defmeth reliability-model-object-proto :p*q-if
  (&optional (values nil set))
  (if set (setf (slot-value 'p*q-if) values))
  (slot-value 'p*q-if))

(defmeth reliability-model-object-proto :point-bis-corr
  (&optional (values nil set))
  (if set (setf (slot-value 'point-bis-corr) values))
  (slot-value 'point-bis-corr)) 

(defmeth reliability-model-object-proto :corrected-point-bis-corr
  (&optional (values nil set))
  (if set (setf (slot-value 'corrected-point-bis-corr) values))
  (slot-value 'corrected-point-bis-corr)) 

(defmeth reliability-model-object-proto :dialog-value
  (&optional (values nil set))
  (if set (setf (slot-value 'dialog-value) values))
  (slot-value 'dialog-value))

(defmeth reliability-model-object-proto :average-correlation
  (&optional (values nil set))
  (if set (setf (slot-value 'average-correlation) values))
  (slot-value 'average-correlation))

(defmeth reliability-model-object-proto :theta
  (&optional (values nil set))
  (if set (setf (slot-value 'theta) values))
  (slot-value 'theta))

(defmeth reliability-model-object-proto :eign
  (&optional (values nil set))
  (if set (setf (slot-value 'eign) values))
  (slot-value 'eign))

(defmeth reliability-model-object-proto :eigenvalues
  (&optional (values nil set))
  (if set (setf (slot-value 'eigenvalues) values))
  (slot-value 'eigenvalues))

(defmeth reliability-model-object-proto :pa-eigen
  (&optional (values nil set))
  (if set (setf (slot-value 'pa-eigen) values))
  (slot-value 'pa-eigen))

(defmeth reliability-model-object-proto :guttman
  (&optional (values nil set))
  (if set (setf (slot-value 'guttman) values))
  (slot-value 'guttman))

(defmeth reliability-model-object-proto :pares
  (&optional (values nil set))
  (if set (setf (slot-value 'pares) values))
  (slot-value 'pares))

(defmeth reliability-model-object-proto :impares
  (&optional (values nil set))
  (if set (setf (slot-value 'impares) values))
  (slot-value 'impares))

(defmeth reliability-model-object-proto :unequal-split
  (&optional (values nil set))
  (if set (setf (slot-value 'unequal-split) values))
  (slot-value 'unequal-split))
(defmeth reliability-model-object-proto :e-axis
  (&optional (values nil set))
  (if set (setf (slot-value 'e-axis) values))
  (slot-value 'e-axis))

(defmeth reliability-model-object-proto :v-axis
  (&optional (values nil set))
  (if set (setf (slot-value 'v-axis) values))
  (slot-value 'v-axis))

(defmeth reliability-model-object-proto :f-matrix
  (&optional (values nil set))
  (if set (setf (slot-value 'f-matrix) values))
  (slot-value 'f-matrix))

(defmeth reliability-model-object-proto :final-comunal
  (&optional (values nil set))
  (if set (setf (slot-value 'final-comunal) values))
  (slot-value 'final-comunal))

(defmeth reliability-model-object-proto :r-recompuesta
  (&optional (values nil set))
  (if set (setf (slot-value 'r-recompuesta) values))
  (slot-value 'r-recompuesta))

(defmeth reliability-model-object-proto :r-residual
  (&optional (values nil set))
  (if set (setf (slot-value 'r-residual) values))
  (slot-value 'r-residual))

(defmeth reliability-model-object-proto :var-unique
  (&optional (values nil set))
  (if set (setf (slot-value 'var-unique) values))
  (slot-value 'var-unique))

(defmeth reliability-model-object-proto :IMPUT-R-MATRIX
  (&optional (values nil set))
  (if set (setf (slot-value 'IMPUT-R-MATRIX) values))
  (slot-value 'IMPUT-R-MATRIX))

(defmeth reliability-model-object-proto :num-factors
  (&optional (values nil set))
  (if set (setf (slot-value 'num-factors) values))
  (slot-value 'num-factors))

;*options*

(defmeth reliability-model-object-proto :options ()

  (setf dialog-val
        (send choice-item-proto :new 
                 (list 
                "Item descriptive analysis"
                "Test score descriptive analysis"
                "Item-Test analysis"               
                "Reliability: Cronbach's Alpha Model"
                "Reliability: Split-Half model"                
                "Reliability: Theta model"
                "Binary Item analysis"                                             
                "Exploratory Factor Analysis"
                ) :value 0))

  (setf text-factors  (send edit-text-item-proto :new "2" :text-length 2))

      (setf OK (send modal-button-proto :new "Ok"
                 :action
               #'(lambda ()                  
                          (if
                       (= (send self :dialog-value (send dialog-val :value)) 7) 
                           (factor-analysis)
                   (let (                         
                         (dialog (send ok :dialog))
                         )
                     (send self :dialog-value (send dialog-val :value))
                     (send self :num-factors (read-from-string (send text-factors :text))))))))
  
  (setf HELP (send modal-button-proto :new "Help"
                 :action

              #'(lambda ()                                    
                         (plot-help-window (strcat "Help for " (send self :title)))
                   (paste-plot-help (format nil "~2%HELP FOR ITEM-TEST ANALYSIS'S OPTIONS:~3%
 ~4% 1) Item escriptive analysis: analyze your item score data, provides descriptive indexes and plots for items ~3% 
2) Test score descriptive analysis: computes total scores from your item score data, and provides indexes and plots for the total test scores ~3% 
3) Item-Test analysis: analyze relationships between items and total score, provides indexes such as discrimination measurement, Test descriptive if- item- deleted, etc. ~3% 4) Reliability: Cronbach's Alpha Model: Computes Cronbach's Alpha, CI for Cronbach's Alpha, SEM and SEE based on Alpha, and Alpha-if-item-deleted ~3% 
5) Reliability: Split-Half model: Split items in two parts (even and uneven) and compute Split-Half indexes, SEM and SEE. It also provides a statistical description for each half ~3% 
6) Reliability: Theta model: Computes Armor's Theta reliability index based on the first PCA eigenvalues from your items data matrix. Provide SEM and SEE. ~3% 
7) Binary item analysis: A more appropriate analysis options if your item data are binary (0 and 1). Provides descriptive analysis, KR20 reliability index, point-biserial-correlation, etc. ~3%
7) Parallel Analysis: It provides a methods for determining the number of factor to retain when use Exploratory Factor Analysis to explore the dimensionality of your items data structure. ~3%
8) Factor Analysis: Principal Axis: Provides non-iterative factor analysis. You may specify the number of factor to retain.~2%")))))

              

  (setf cancel (send modal-button-proto :new "Cancel"
                     :action
               #'(lambda ()
                   (let (
                         (dialog (send cancel :dialog))
                         )
                     (send dialog :modal-dialog-return nil)))))

(setf vista-rel-dialog
      (send modal-dialog-proto :new 
            (list 
             (list dialog-val)            

             (list ok cancel help))
			:default-button ok :title "Options for Item-Test Analysis"
            ))

             (setf result (send vista-rel-dialog :modal-dialog))
             result)

;;;;;;;;;;;;;;;
(defmeth reliability-model-object-proto :isnew (&rest args)
  (cond   
    ((< (send current-data :active-nvar '(numeric)) 1)
     (error-message (format nil "Cannot analyze data ~
                that has less than one active numeric variables."))
     (send *toolbox* :reset-button "TestRel"))
    (t
     (send self :model-abbrev "TestRel")     
     (apply #'call-next-method args))))


(defmeth reliability-model-object-proto :analysis ()         
  (let* (
         (dialog-value (send self :dialog-value))
         (data (send current-data :active-data-matrix '(numeric)))
         (nobs (send current-data :active-nobs))
         (scale (mapcar #'sum (row-list data))) 
         (scale-if (column-list (make-array (array-dimensions data)  :initial-contents(mapcar #'- scale  (row-list data)))));calcula las escalas sacando los items de a uno.
         (n-items (array-dimension data 1));calcula numero de items
         (n-items-1 (- n-items 1));numero de items menos 1
         
         (item-correlation-matrix (correlation-matrix data))
         (average-correlation (/ (- (sum item-correlation-matrix) n-items) ( - (* n-items n-items) n-items)))
         
         (item-variances  (mapcar #'variance (column-list data)));varianzas de los items  
         (item-std  (mapcar #'standard-deviation (column-list data))) ;std de los items 
         (item-kurtosis  (mapcar #'kurtosis (column-list data))) ;kurtosis items 
         (item-skewness  (mapcar #'skewness (column-list data))) ;skewness items 
         
    (suma-item-variances (sum item-variances));suma de las varianzas de los items
         (scale-variance (variance scale));varianza de la escala
         (scale-std (standard-deviation scale));std de la escala
         (scale-kurtosis (kurtosis scale))
         (scale-kurtosis-if (mapcar #'kurtosis scale-if))
         (scale-skewness (skewness scale))
         (scale-skewness-if (mapcar #'skewness scale-if))
         (scale-variance-if (mapcar #'variance scale-if));varianza de la escala borrando items.
         (scale-std-if (mapcar #'standard-deviation scale-if));std. de la escala borrando items.
         (suma-item-variances-if (mapcar #'(lambda (x) (-  (sum item-variances) x))item-variances));suma de las varianzas de los items borrando los items
         (item-means (mapcar #'mean (column-list data)));medias de los items
         (scale-mean (mean scale));media de la escala
    (scale-mean-if (mapcar #'mean scale-if));media de la escala si se quitan los items
         (pre-impares (* 2 (iseq n-items)))
         (pares (reverse (set-difference (iseq n-items) pre-impares)))
         (impares (reverse (set-difference (iseq n-items) pares)))
         (item-impares  (select (column-list data) impares))
         (impares-matrix (make-array (list (length impares) nobs) :initial-contents item-impares))
         (item-pares  (select (column-list data) pares))
         (pares-matrix (make-array (list (length pares) nobs)  :initial-contents item-pares))
         (scale-pares (mapcar #'sum (column-list  pares-matrix)))
         (scale-impares (mapcar #'sum (column-list  impares-matrix)))
         (k1 (length pares))
         (k2 (length impares))

         (orden-data (transpose (make-array (list n-items nobs) :initial-contents (mapcar #'sort-data (column-list data)))))
         ;(data-index (mapcar #'remove-duplicates (column-list orden-data)))
         ;(pre-control (mapcar #'length data-index))
         ;(control-dicotomico (compare pre-control (repeat 2  n-items)))
         
         (incorr-data (cond 
                        ((= dialog-value 6) (mapcar #'(lambda (x) (position '1 x)) (column-list orden-data)))
                        (t nil)))
         (corr-data (cond 
                      ((= dialog-value 6) (mapcar #'(lambda (x) (- nobs x)) incorr-data))
                      (t nil)))
         (p (cond 
              ((= dialog-value 6)(mapcar #'(lambda (x) (/ x nobs)) corr-data))
              (t nil)))
         (q (cond 
              ((= dialog-value 6) (mapcar #'(lambda (x)(- 1 x)) p))
              (t nil)))
         (kuder (cond 
                  ((= dialog-value 6)
                   (* (/ n-items (- n-items 1))(- 1 (/ (sum (* p q)) scale-variance))))
                  (t nil)))
         
         (p*q-if (cond 
                   ((= dialog-value 6)(mapcar #'(lambda (x) (- (sum (* p q)) x)) (* p q)))
                   (t nil)))
   
      (kuder-if (cond 
                     ((= dialog-value 6)
                      (mapcar #'(lambda (x y) (* (/ n-items-1 (- n-items-1 1))
                                                                         (- 1 (/ (sum x y))))) p*q-if scale-variance-if))
                     (t nil)))

         (means-p  (cond 
                     ((= dialog-value 6) (mapcar #'(lambda (x) (mean (select scale (positions x 1)))) (column-list data)))
                       (t nil)))

         (means-q (cond 
                     ((=  dialog-value 6) (mapcar #'(lambda (x) (mean (select scale (positions x 0)))) (column-list data)))
                       (t nil)))

         (point-bis-corr (cond 
                     ((= dialog-value 6) (mapcar #'(lambda (mean-p mean-q p q) (* (/ (- mean-p mean-q) (standard-deviation scale)) (sqrt (* p q)))) means-p means-q p q))
                                (t nil)))
         (means-p-if (cond 
                     ((= dialog-value 6) (mapcar #'(lambda (x y) (mean (select y (positions x 1)))) (column-list data) scale-if))
                       (t nil)))

         (means-q-if  (cond 
                     ((= dialog-value 6) (mapcar #'(lambda (x y) (mean (select y (positions x 0))))        (column-list data) scale-if))
                       (t nil)))

         (corrected-point-bis-corr (cond 
                     ((= dialog-value 6) (mapcar #'(lambda (mean-p-if mean-q-if p q) 
 (* (/ (- mean-p-if mean-q-if) (standard-deviation scale-if)) (sqrt (* p q)))) means-p-if means-q-if p q))
                       (t nil)))
                           
         (split-half  (/ (* 2 (correlation scale-pares scale-impares)) (+ 1 (correlation scale-pares scale-impares))))
         
         (unequal-split 
          (let* (
                 (r (correlation scale-pares scale-impares))
                 (r2 (* r r))
                 (r4 (* r2 r r))
                 (k (* (+ k1 k2) (+ k1 k2)))
                 (4r2 (* 4 r2))
                 (1-r2 (- 1 r2))
                 )    
            (/ 
             (+ (- r2) (sqrt (+ r4 (/(* 4r2 1-r2 k1 k2) k))))
             (/(* 2 1-r2 k1 k2) k))
            ))
         
         
         (guttman (* 2 (- 1 (/ (+ (variance scale-pares) (variance scale-impares)) scale-variance))))
         
         (alfa (* 
                (/ n-items n-items-1)
                (- 1 (/ suma-item-variances scale-variance))))
         
         (alfa-if (mapcar #'(lambda
                              (suma-item-variances-if scale-variance-if)
                              (* 
                               (/ n-items-1 (- n-items-1 1))
                               (- 1 (/ suma-item-variances-if scale-variance-if))))
                          suma-item-variances-if scale-variance-if));
         
         (left-alpha 1)
         (prepped-data
          (/ (normalize (center data) 1) (sqrt (1- nobs))))
         (corcovmat (matmult (transpose prepped-data) prepped-data))
         (svd (sv-decomp2 prepped-data)) 
         (svd (if (< (sum (col (select svd 2) 0)) 0)
                  (list (* -1 (select svd 0))
                        (select svd 1)
                        (* -1 (select svd 2))
                        (select svd 3))
                  svd))
         (scores (matmult (select  svd 0) 
                          (diagonal (^ (select svd 1) left-alpha))))
         (eigenvalues (^ (select svd 1) 2))
         (coefs (matmult (select  svd 2) 
                         (diagonal (^ (select svd 1)(1- left-alpha)))))
         (var-rel-contrib (^ (matmult coefs (diagonal (select svd 1))) 2))
         (sqrt-obs-coord-row-list (row-list (^ (* scores (sqrt nobs)) 2)))
         (obs-rel-contrib (apply (function bind-rows) 
                                 (/ sqrt-obs-coord-row-list 
                                    (mapcar #'sum sqrt-obs-coord-row-list))))
         (eign (select eigenvalues 0))
         (theta (* (/ n-items (- n-items 1)) (- 1 (/ 1 eign))))
         
         (pa-eigen
          (mapcar #'(lambda (k)
                      (exp  (+ 
                             -0.130827
                             (* -0.444853 k)
                             (* -0.008497 (* k k)) 
                             (* 0.639462 (log n-items))
                             (* (* 0.059901 k) (log Nobs))
                             (* -0.078631 (* (log Nobs) (log n-items)))
                             (* (* 0.001488 (* k k)) (log Nobs))
                             (* (* 0.095875 k) (log n-items))
                             (* (* 0.001576 (* k k)) (log n-items))
                             (* (* -0.013331 k) (* (log Nobs) (log n-items)))
                             (* (* -0.000278 (* k k)) (* (log Nobs) (log n-items)))
                             ))) (iseq n-items)))

;Principal axis Factor Analysis
         
         (factor-analysis 
       (let* (
                 (predictors (mapcar #'(lambda (x) (my-predictor-index x  n-items data)) (iseq n-items)))
                 (responses (mapcar #'(lambda (x) (select (column-list data) x)) (iseq n-items)))
                 (prev-comunal (mapcar #'(lambda (x y) (send (regression-model x y :print nil) :R-SQUARED)) predictors responses))
                 (r-matrix-new (mapcar #'(lambda (x y) (setf (select item-correlation-matrix x x) y)) (iseq n-items) prev-comunal))
                 (my-r-matrix item-correlation-matrix)
                 (e-all (eigenvalues my-r-matrix))
                 (e (select e-all (iseq  (send self :num-factors))))
                 (v-all (eigenvectors my-r-matrix))
                 (v (select v-all (iseq (length e))))
              (f-mat (transpose (make-array (list (length e) n-items) :initial-contents (combine (*  (sqrt e) v)))))
              (final-com (mapcar #'sum (row-list (^ f-mat 2))))
              (r-recomp (matmult  f-mat (transpose f-mat)))
              (r-residu (- my-r-matrix r-recomp))
              (var-uniq  (- (repeat  1 n-items) (diagonal r-recomp)))
              )
         (setf IMPUT-R-MATRIX my-r-matrix)
         (setf e-axis e)
         (setf v-axis v)
         (setf f-matrix f-mat)
         (setf final-comunal final-com)
         (setf r-recompuesta r-recomp)
         (setf r-residual r-residu)
         (setf var-unique var-uniq)
         )
          )
         
         (send self :data data)
         )
    
    (send self :IMPUT-R-MATRIX IMPUT-R-MATRIX)
    (send self :e-axis e-axis)
    (send self :v-axis v-axis)
    (send self :f-matrix f-matrix)
    (send self :final-comunal final-comunal)
    (send self :r-recompuesta r-recompuesta)
    (send self :r-residual r-residual)
    (send self :var-unique var-unique)         
    (send self :Split-Half Split-Half)
    (send self :guttman guttman)
    (send self :scale-pares scale-pares)
    (send self :scale-impares scale-impares)      
    (send self :data data)  
    (send self :scale scale)
    (send self :scale-if scale-if)
    (send self :n-items n-items)
    (send self :item-variances item-variances)
    (send self :item-std item-std)
    (send self :item-kurtosis item-kurtosis)
    (send self :item-skewness item-skewness)
    (send self :scale-variance scale-variance)
    (send self :scale-variance-if  scale-variance-if)
    (send self :scale-std scale-std)
    (send self :scale-skewness scale-skewness)
    (send self :scale-skewness-if scale-skewness-if)
    (send self :scale-kurtosis scale-kurtosis)
    (send self :scale-kurtosis-if scale-kurtosis-if)
    (send self :scale-std-if scale-std-if)
    (send self :item-means item-means)
    (send self :scale-mean scale-mean)
    (send self :scale-mean-if scale-mean-if)
    (send self :alfa alfa)
    (send self :alfa-if alfa-if)
    (send self :kuder kuder)
    (send self :kuder-if kuder-if)
    (send self :p p)    
    (send self :q q)
    (send self :p*q-if p*q-if)
    ;(send self :data-index data-index)
    ;(send self :control-dicotomico control-dicotomico)
    (send self :dialog-value dialog-value)
    (send self :average-correlation)
    (send self :eign eign)
    (send self :eigenvalues eigenvalues)
    (send self :pa-eigen pa-eigen)
    (send self :theta theta)
    (send self :pares pares)
    (send self :impares impares)
    (send self :unequal-split unequal-split)
  (send self :point-bis-corr point-bis-corr)
    (send self :corrected-point-bis-corr corrected-point-bis-corr)


    )
  )